######################################################### SOURCE CODE FILE 1 (For FIGURE 1D) ###########################################################################
# Loading in required packages

library(readxl)
library(forcats)
library(ggplot2)
library(ggpubr)
library(dplyr)
library(segmented)
library(readxl)
library(plyr)
library(caret)
library(corrplot)

# Loading in data
datCoupling <- read_excel("your file path for dataset")

## reordering factors within dataset datCoupling 

datCoupling$Group <- factor(datCoupling$Group, levels = c("G8to10", "G12to14", "G16to18","G20to30"))
datCoupling$Group <- revalue(datCoupling$Group, c("G8to10"="8 to 10", "G12to14"="12 to 14","G16to18"="16 to 18", "G20to30"="20 to 30"))

str(datCoupling)

####################### One-way ANOVA for Performance analysis #########################

aov_RMSE <- aov(Performance ~ Group, data=datCoupling)
anova(aov_RMSE)
with(datCoupling, pairwise.t.test(Performance, Group, p.adj = "holm"))

####################### Performance results - FIGURE 1 #########################

#Plot results for performance analysis
pboxplot <- ggboxplot(datCoupling, x="Group", y="Performance", color="black", fill="Group", alpha = 0.25, add="jitter", add.params = list(shape = 21, size = 2.5), palette="lancet", ylab="Precision grip performance (a.u.)", xlab="Age group (years old)")
pboxplot
